/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.github.noeppi_noeppi.libx.LibX;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.math.vector.Vector4f;
import org.lwjgl.system.MemoryStack;

public class RenderHelper {
    public static final ResourceLocation TEXTURE_WHITE = new ResourceLocation(LibX.getInstance().modid, "textures/white.png");
    private static final ResourceLocation TEXTURE_CHEST_GUI = new ResourceLocation("minecraft", "textures/gui/container/generic_54.png");

    public static void repeatBlit(MatrixStack matrixStack, int x, int y, int displayWidth, int displayHeight, TextureAtlasSprite sprite) {
        RenderHelper.repeatBlit(matrixStack, x, y, sprite.func_94211_a(), sprite.func_94216_b(), displayWidth, displayHeight, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h());
    }

    public static void repeatBlit(MatrixStack ms, int x, int y, int texWidth, int texHeight, int displayWidth, int displayHeight, TextureAtlasSprite sprite) {
        RenderHelper.repeatBlit(ms, x, y, texWidth, texHeight, displayWidth, displayHeight, sprite.func_94209_e(), sprite.func_94212_f(), sprite.func_94206_g(), sprite.func_94210_h());
    }

    public static void repeatBlit(MatrixStack ms, int x, int y, int texWidth, int texHeight, int displayWidth, int displayHeight, float minU, float maxU, float minV, float maxV) {
        int pixelsNowX;
        for (int pixelsRenderedX = 0; pixelsRenderedX < displayWidth; pixelsRenderedX += pixelsNowX) {
            int pixelsNowY;
            pixelsNowX = Math.min(texWidth, displayWidth - pixelsRenderedX);
            float maxUThisTime = maxU;
            if (pixelsNowX < texWidth) {
                maxUThisTime = minU + (maxU - minU) * ((float)pixelsNowX / (float)texWidth);
            }
            for (int pixelsRenderedY = 0; pixelsRenderedY < displayHeight; pixelsRenderedY += pixelsNowY) {
                pixelsNowY = Math.min(texHeight, displayHeight - pixelsRenderedY);
                float maxVThisTime = maxV;
                if (pixelsNowY < texHeight) {
                    maxVThisTime = minV + (maxV - minV) * ((float)pixelsNowY / (float)texHeight);
                }
                AbstractGui.func_238461_a_((Matrix4f)ms.func_227866_c_().func_227870_a_(), (int)(x + pixelsRenderedX), (int)(x + pixelsRenderedX + pixelsNowX), (int)(y + pixelsRenderedY), (int)(y + pixelsRenderedY + pixelsNowY), (int)0, (float)minU, (float)maxUThisTime, (float)minV, (float)maxVThisTime);
            }
        }
    }

    public static void renderIconColored(MatrixStack matrixStack, IVertexBuilder buffer, float x, float y, TextureAtlasSprite sprite, float width, float height, float alpha, int color, int light, int overlay) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        Matrix4f mat = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, x, y + height, 0.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94209_e(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(mat, x + width, y + height, 0.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94212_f(), sprite.func_94210_h()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(mat, x + width, y, 0.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94212_f(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(mat, x, y, 0.0f).func_225586_a_(red, green, blue, (int)(alpha * 255.0f)).func_225583_a_(sprite.func_94209_e(), sprite.func_94206_g()).func_227891_b_(overlay).func_227886_a_(light).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
    }

    public static void color(int color) {
        RenderSystem.color3f((float)((float)(color >>> 16 & 0xFF) / 255.0f), (float)((float)(color >>> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
    }

    public static void resetColor() {
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void renderText(String text, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        float widthHalf = (float)Minecraft.func_71410_x().field_71466_p.func_78256_a(text) / 2.0f;
        Minecraft.func_71410_x().field_71466_p.getClass();
        float heightHalf = 9.0f / 2.0f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(-(widthHalf + 2.0f)), (double)(-(heightHalf + 2.0f)), 0.0);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        GlStateManager.func_227702_d_((float)0.2f, (float)0.2f, (float)0.2f, (float)0.8f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_WHITE);
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)((int)(2.0f * widthHalf) + 4), (int)((int)(2.0f * heightHalf) + 4), (int)256, (int)256);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        matrixStack.func_227861_a_((double)(widthHalf + 2.0f), (double)(heightHalf + 2.0f), 10.0);
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(matrixStack, text, -widthHalf, -heightHalf, 0xFFFFFF);
        matrixStack.func_227865_b_();
    }

    public static void addQuadWithAlpha(IVertexBuilder vertex, MatrixStack.Entry matrix, BakedQuad quad, float red, float green, float blue, float alpha, int light, int overlay, boolean mulColor, boolean mulAlpha) {
        int[] vertexData = quad.func_178209_a();
        Vector3i vector3i = quad.func_178210_d().func_176730_m();
        Vector3f vector3f = new Vector3f((float)vector3i.func_177958_n(), (float)vector3i.func_177956_o(), (float)vector3i.func_177952_p());
        Matrix4f matrix4f = matrix.func_227870_a_();
        vector3f.func_229188_a_(matrix.func_227872_b_());
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormats.field_176600_a.func_177338_f());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int i = 0; i < vertexData.length / 8; ++i) {
                float b;
                float g;
                float r;
                intbuffer.clear();
                intbuffer.put(vertexData, i * 8, 8);
                float x = bytebuffer.getFloat(0);
                float y = bytebuffer.getFloat(4);
                float z = bytebuffer.getFloat(8);
                float a = mulAlpha ? (float)(bytebuffer.get(15) & 0xFF) / 255.0f * alpha : alpha;
                if (mulColor) {
                    r = (float)(bytebuffer.get(12) & 0xFF) / 255.0f * red;
                    g = (float)(bytebuffer.get(13) & 0xFF) / 255.0f * green;
                    b = (float)(bytebuffer.get(14) & 0xFF) / 255.0f * blue;
                } else {
                    r = red;
                    g = green;
                    b = blue;
                }
                int l = vertex.applyBakedLighting(light, bytebuffer);
                float u = bytebuffer.getFloat(16);
                float v = bytebuffer.getFloat(20);
                Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
                vector4f.func_229372_a_(matrix4f);
                vertex.applyBakedNormals(vector3f, bytebuffer, matrix.func_227872_b_());
                vertex.func_225588_a_(vector4f.func_195910_a(), vector4f.func_195913_b(), vector4f.func_195914_c(), r, g, b, a, u, v, overlay, l, vector3f.func_195899_a(), vector3f.func_195900_b(), vector3f.func_195902_c());
            }
        }
    }

    public static void renderGuiBackground(MatrixStack matrixStack, int x, int y, int width, int height) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_CHEST_GUI);
        RenderHelper.repeatBlit(matrixStack, x + 2, y + 2, 162, 14, width - 4, height - 4, 0.02734375f, 0.66015625f, 0.48828125f, 0.54296875f);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)4, (int)4, (int)256, (int)256);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)(x + width - 5), (int)y, (int)0, (float)172.0f, (float)0.0f, (int)4, (int)4, (int)256, (int)256);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)x, (int)(y + height - 5), (int)0, (float)0.0f, (float)218.0f, (int)4, (int)4, (int)256, (int)256);
        AbstractGui.func_238464_a_((MatrixStack)matrixStack, (int)(x + width - 5), (int)(y + height - 5), (int)0, (float)172.0f, (float)218.0f, (int)4, (int)4, (int)256, (int)256);
        RenderHelper.repeatBlit(matrixStack, x + 4, y, 169, 3, width - 8, 3, 0.015625f, 0.67578125f, 0.0f, 0.01171875f);
        RenderHelper.repeatBlit(matrixStack, x + 4, y + height - 4, 169, 3, width - 8, 3, 0.015625f, 0.67578125f, 0.85546875f, 0.8671875f);
        RenderHelper.repeatBlit(matrixStack, x, y + 4, 3, 214, 3, height - 8, 0.0f, 0.01171875f, 0.015625f, 0.8515625f);
        RenderHelper.repeatBlit(matrixStack, x + width - 4, y + 4, 3, 214, 3, height - 8, 0.67578125f, 0.6875f, 0.015625f, 0.8515625f);
    }
}

